#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct {
    double ang;
    long long x, y;
    int idx;
} Vec;

int cmp(const void *a, const void *b) {
    double d = ((Vec*)a)->ang - ((Vec*)b)->ang;
    if (d < 0) return -1;
    if (d > 0) return 1;
    return 0;
}

int main() {
    int n;
    scanf("%d", &n);

    Vec *v = malloc(sizeof(Vec) * 2 * n);

    for (int i = 0; i < n; i++) {
        scanf("%lld %lld", &v[i].x, &v[i].y);
        v[i].ang = atan2(v[i].y, v[i].x);
        v[i].idx = i + 1;
    }

    qsort(v, n, sizeof(Vec), cmp);

    for (int i = 0; i < n; i++) {
        v[i + n] = v[i];
        v[i + n].ang += 2 * M_PI;
    }

    long long best = 0;
    int bestL = 0, bestR = -1;

    long long sx = 0, sy = 0;
    int l = 0;

    for (int r = 0; r < 2 * n; r++) {
        sx += v[r].x;
        sy += v[r].y;

        while (v[r].ang - v[l].ang > M_PI) {
            sx -= v[l].x;
            sy -= v[l].y;
            l++;
        }

        long long cur = sx * sx + sy * sy;
        if (cur > best) {
            best = cur;
            bestL = l;
            bestR = r;
        }
    }

    int k = bestR - bestL + 1;
    printf("%d\n", k);
    for (int i = bestL; i <= bestR; i++) {
        printf("%d ", v[i].idx);
    }
    printf("\n");

    free(v);
    return 0;
}